% fskprotokoll.cls
% 2023-09-05: created by Katrin Katzenmeier based on "Protokollklasse der Fachschaft Physik" 
% Based on:
% fsprotokoll.cls (2008-June-04)
% Needs:
% tudexercise.cls (fileversion 1.3 or newer)

% --- Class structure: identification part
% ---
\ProvidesClass{fskprotokoll}[2009/07/12 v0.09 Protokoll von FS-Sitzungen]
\NeedsTeXFormat{LaTeX2e}


\newif\ifShowMembers \ShowMembersfalse
\newif\ifShowTimeBegin \ShowTimeBeginfalse
\newif\ifShowTimeEnd \ShowTimeEndfalse
\newif\ifShowProtocolWriter \ShowProtocolWriterfalse
\newif\ifShoworganizer \Showorganizerfalse
\newif\ifShowModerator \ShowModeratorfalse
\newif\ifShowDate \ShowDatefalse
\newif\ifUTF \UTFfalse

% ---
% --- Class structure: initial code part
% ---

% what is meeting? 
\def\@committee{FSK}
\newcommand{\setcommittee}[1]{\def\@committee{#1}}
\newcommand{\show@committee}{\@committee}

% who is meeting? 
\def\@members{Niemand}
\newcommand{\setmembers}[1]{\def\@members{#1}\ShowMemberstrue}
\newcommand{\show@members}{\@members}
\newcommand{\Anwesend}[1]{\setmembers{#1}}

% what day is it?
\def\@date{\today}
\newcommand{\setdate}[1]{\def\@date{#1}\ShowDatetrue}
\newcommand{\show@date}{\@date}
\newcommand{\Tag}[1]{\setdate{#1}}

% when did it start?
\def\@timebegin{16:30}
\newcommand{\settimebegin}[1]{\def\@timebegin{#1}\ShowTimeBegintrue}
\newcommand{\show@timebegin}{\@timebegin}
\newcommand{\Beginn}[1]{\settimebegin{#1}}

% when did it end?
\def\@timeend{18:45}
\newcommand{\settimeend}[1]{\def\@timeend{#1}\ShowTimeEndtrue}
\newcommand{\show@timeend}{\@timeend}
\newcommand{\Ende}[1]{\settimeend{#1}}

% protocol writer
\def\@protocolwriter{Leer}
\newcommand{\setprotocolwriter}[1]{\def\@protocolwriter{#1}\ShowProtocolWritertrue}
\newcommand{\show@protocolwriter}{\@protocolwriter}
\newcommand{\Protokollant}[1]{\setprotocolwriter{#1}}


%Organizer
\def\@organizer{Leer}
\newcommand{\setorganizer}[1]{\def\@organizer{#1}\Showorganizertrue}
\newcommand{\show@organizer}{\@organizer}
\newcommand{\Ausrichtend}[1]{\setorganizer{#1}}

% moderator
\def\@moderator{Leer}
\newcommand{\setmoderator}[1]{\def\@moderator{#1}\ShowModeratortrue}
\newcommand{\show@moderator}{\@moderator}
\newcommand{\Moderator}[1]{\setmoderator{#1}}
\newcommand{\Redeleitung}[1]{\setmoderator{#1}}



\newcommand{\setParagraphSpacing}{}

\DeclareOption{noparindent}{%
  \renewcommand{\setParagraphSpacing}{\setlength{\parindent}{0pt}\setlength{\parskip}{1ex plus 1ex minus 0.2ex}}%
}
\DeclareOption{utf8}{\UTFtrue}

% unrecognized options
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{tudaexercise}}

\PassOptionsToClass{a4paper}{scrartcl}



\ProcessOptions \relax

%hier Farbe ändern
\LoadClass[parskip=half,numbersubsubsec,nopartpage,color=8a]{tudaexercise}


% ====




\ifUTF
  \RequirePackage[utf8]{inputenc}
\else
  \RequirePackage[latin9]{inputenc}
\fi
\RequirePackage{tocloft}
\RequirePackage[ngerman]{babel}


% --- Class structure: main code part
% ---

\AtBeginDocument{
	\renewcommand*\thesection{TOP \@arabic\c@section}
	\renewcommand*\thesubsection{\@arabic\c@section.\@arabic\c@subsection}
	\renewcommand*\thesubsubsection{\@arabic\c@section.\@arabic\c@subsection.\@arabic\c@subsubsection}
	\setcounter{tocdepth}{1}
	\ProtokollKopf
}

%feststehende Infos
\title{\show@committee \\ Sitzungsprotokoll}
\subtitle{\show@organizer}



%Header
\newcommand{\ProtokollKopf}{
\maketitle
\head@list
}

\newcommand{\head@list}{
\begin{tabular}{p{0.14\textwidth}p{0.79\textwidth}}
\ifShowTimeBegin
  \textbf{Beginn:} & \show@timebegin{} Uhr \\
\fi
\ifShowTimeEnd
  \textbf{Ende:} & \show@timeend{} Uhr\\
\fi
\end{tabular}

\begin{tabular}{p{0.18\textwidth}p{0.27\textwidth}p{0.18\textwidth}p{0.27\textwidth}}
\ifShoworganizer
	\textbf{Ausrichtend:} & \show@organizer
\fi
\ifShowProtocolWriter
	& \textbf{Protokollierend:} & \show@protocolwriter \\
\else
	& & \\
\fi
\ifShowModerator
	\textbf{Redeleitung:} & \show@moderator
\else
	& & \\	
\fi
\end{tabular}

\begin{tabular}{p{\textwidth}p{0.79\textwidth}}
\ifShowMembers
  \textbf{Anwesende:} & \show@members \\
\fi
\end{tabular}

\renewcommand{\contentsname}{Tagesordnungspunkte}
\tableofcontents
}


% commands anpassen
\newcommand{\TOP}[1]{\section{#1}}
\newcommand{\Top}[1]{\TOP{#1}}
\newcommand{\SubTOP}[1]{\subsection{#1}}
\newcommand{\subTOP}[1]{\SubTOP{#1}}
\newcommand{\subTop}[1]{\SubTOP{#1}}
\newcommand{\SubTop}[1]{\SubTOP{#1}}
\newcommand{\subsubTOP}[1]{\subsubsection{#1}}
\newcommand{\SubSubTOP}[1]{\subsubTOP{#1}}
\newcommand{\SubSubTop}[1]{\subsubTOP{#1}}
\newcommand{\subsubTop}[1]{\subsubTOP{#1}}

\usepackage{url}
\usepackage[right]{eurosym}
%\newcommand{\texteuro}{\euro{}}
%\renewcommand{\cftsecpresnum}{TOP~}
%\renewcommand{\cftsecaftersnum}{:}
\setlength\cftsecnumwidth{1.7cm}
\setlength\cftbeforesecskip{0mm}
\renewcommand{\cftsecdotsep}{0}
% \renewcommand{\contentsname}{Tagesordnungspunkte}
% \renewcommand*\thesection{TOP \@arabic\c@section:}
% \renewcommand*\thesubsection{\@arabic\c@section.\@arabic\c@subsection}
% \renewcommand*\thesubsubsection{\@arabic\c@section.\@arabic\c@subsection.\@arabic\c@subsubsection}
% \setcounter{tocdepth}{1}

